//=============================================================================
// ExtraCritical.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/07/17 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 多段クリティカル機構追加機能_クリティカル効果音
 * @target MZ
 * @author くろあめ
 *
 * @param criticalSe
 * @text クリティカル効果音
 * @desc クリティカルが発生したときの演奏する効果音です。
 * @default
 * @type struct<SE>
 *
 * @help
 * 多段クリティカルの発生時に
 * 任意の効果音を演奏する機能を追加します。
 * 
 * このプラグインは、多段クリティカル機構プラグイン
 * 「ExtraCritical.js」に機能追加を行うプラグインです
 * 動作には本体である「ExtraCritical.js」導入が前提となります
 * 必ず「ExtraCritical.js」より下に導入してください。
 * 
 * また、このプラグインの利用には
 * MZ公式のDLCプラグイン「PluginCommonBase.js」が必要です
 * 「PluginCommonBase.js」は、RPGツクールMZのインストールフォルダ配下の
 * 以下のフォルダに格納されています。
 * dlc/BasicResources/plugins/official
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */
 
/*~struct~SE:
 *
 * @param name
 * @text SEファイル名
 * @desc SEのファイル名です。
 * @require 1
 * @dir audio/se/
 * @type file
 * @default
 *
 * @param volume
 * @text SEボリューム
 * @desc SEのボリュームです。
 * @type number
 * @default 90
 * @min 0
 * @max 100
 *
 * @param pitch
 * @text SEピッチ
 * @desc SEのピッチです。
 * @type number
 * @default 100
 * @min 50
 * @max 150
 *
 * @param pan
 * @text SEバランス
 * @desc SEの左右バランスです。
 * @type number
 * @default 0
 * @min -100
 * @max 100
 */

(function() {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

const _Window_BattleLog_displayCritical_criticalSE = Window_BattleLog.prototype.displayCritical;
Window_BattleLog.prototype.displayCritical = function(target) {
    if (target.result().critical) {
        if (param.criticalSe && param.criticalSe.name) {
            AudioManager.playSe(param.criticalSe);
        }
    }
    _Window_BattleLog_displayCritical_criticalSE.apply(this, arguments);
};

})();